#include <stdio.h>
#include <omp.h>

#define ARRAY_SIZE 1000000  // 1 million elements

int main() {
    int array[ARRAY_SIZE];
    long long sum = 0;

    // Initialize array with values
    for (int i = 0; i < ARRAY_SIZE; i++) {
        array[i] = i + 1;  // Example: Summing numbers from 1 to ARRAY_SIZE
    }

    // Measure time for parallel sum
    double start = omp_get_wtime();

    // Parallel sum calculation
    #pragma omp parallel for reduction(+:sum) num_threads(5)
    for (int i = 0; i < ARRAY_SIZE; i++) {
        sum += array[i];
    }

    double end = omp_get_wtime();
    printf("Parallel Sum: %lld\n", sum);
    printf("Time taken (Parallel): %f seconds\n", end - start);

    return 0;
}
